function initBBEditor(editorId, height) {
    const editor = new EasyMDE({
        element: document.getElementById(editorId),
        autoDownloadFontAwesome: false,
        spellChecker: false,
        status: false,
        minHeight: height,
        placeholder: "Write your reply here...",
        toolbar: [
            "bold", "italic", "strikethrough", "|",
            "heading", "code", "quote", "|",
            "unordered-list", "ordered-list", "|",
            "link", "image", "|",
            "preview", "side-by-side", "fullscreen", "|",
            {
                name: "emoji",
                action: toggleEmojiPicker,
                className: "fa fa-smile-o",
                title: "Insert Emoji",
            },
        ],
        theme: "bb-dark",
        insertTexts: {
            link: ["[", "](https://)"],
            image: ["![", "](https://)"],
        },
    });

    // Custom emoji picker functionality
    function toggleEmojiPicker(editor) {
        const emojiPicker = document.getElementById('emoji-picker');
        
        if (emojiPicker) {
            // Toggle visibility if the picker already exists
            emojiPicker.classList.toggle('show');
        } else {
            // Create and show the emoji picker
            createEmojiPicker(editor);
        }
    }

    function createEmojiPicker(editor) {
        const emojis = [
            "😀", "😃", "😄", "😁", "😆", "😅", "🤣", "😂", "🙂", "🙃", 
            "😉", "😊", "😇", "🥰", "😍", "😘", "😗", "😚", "😙", "😋", 
            "😛", "😜", "😝", "🤪", "🤨", "🧐", "🤓", "😎", "🤩", "🥳"
        ];

        const picker = document.createElement('div');
        picker.id = 'emoji-picker';
        picker.className = 'emoji-picker';

        emojis.forEach(emoji => {
            const emojiBtn = document.createElement('button');
            emojiBtn.innerText = emoji;
            emojiBtn.type = 'button';
            emojiBtn.addEventListener('click', () => {
                const codemirror = editor.codemirror;
                const cursorPos = codemirror.getCursor();
                codemirror.replaceRange(emoji, cursorPos);
                picker.classList.remove('show');
            });
            picker.appendChild(emojiBtn);
        });

        // Close button
        const closeBtn = document.createElement('button');
        closeBtn.className = 'close-emoji-picker';
        closeBtn.innerHTML = '&times;';
        closeBtn.addEventListener('click', () => {
            picker.classList.remove('show');
        });
        picker.appendChild(closeBtn);

        // Position the picker below the toolbar
        const toolbarEmoji = document.querySelector('.editor-toolbar .fa-smile-o').closest('button');
        const rect = toolbarEmoji.getBoundingClientRect();
        
        picker.style.position = 'absolute';
        picker.style.top = `${rect.bottom + window.scrollY}px`;
        picker.style.left = `${rect.left + window.scrollX}px`;
        
        document.body.appendChild(picker);
        picker.classList.add('show');

        // Close picker when clicking outside
        document.addEventListener('click', (e) => {
            if (!picker.contains(e.target) && !toolbarEmoji.contains(e.target)) {
                picker.classList.remove('show');
            }
        });
    }

    // Add custom classes for styling
    const editorElement = document.querySelector(`.EasyMDEContainer#${editorId}-easymde`);
    if (editorElement) {
        editorElement.classList.add('bb-editor-custom');
    }

    return editor;
}